/*
 * Decompiled with CFR 0.152.
 */
package com.vtiger.vtwsclib;

import com.vtiger.vtwsclib.helpers.HTTP_Client;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class WSClient {
    String _servicebase = "webservice.php";
    HTTP_Client _client;
    String _serviceurl;
    String _serviceuser;
    String _servicekey;
    String _servertime;
    String _expiretime;
    String _servicetoken;
    String _sessionid;
    Object _userid;
    Object _lasterror;

    public WSClient(String url) {
        this._serviceurl = this.getWebServiceURL(url);
        this._client = new HTTP_Client(this._serviceurl);
    }

    public void reinitailize() {
        this._client = new HTTP_Client(this._serviceurl);
    }

    protected String getWebServiceURL(String url) {
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        return String.valueOf(url) + this._servicebase;
    }

    public Object getId(String id) {
        String[] splits = id.split("x");
        return splits[1];
    }

    public boolean hasError(Object result) {
        boolean isError = false;
        try {
            JSONObject resultObject;
            if (result == null) {
                isError = true;
            } else if (result instanceof Exception) {
                this._lasterror = ((Exception)result).getMessage();
                isError = true;
            } else if (result instanceof JSONObject && (resultObject = (JSONObject)result).get("success").toString() == "false") {
                this._lasterror = resultObject.get("error");
                isError = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isError;
    }

    public Object lastError() {
        return this._lasterror;
    }

    protected boolean __doChallenge(String username) {
        HashMap<String, String> getdata = new HashMap<String, String>();
        getdata.put("operation", "getchallenge");
        getdata.put("username", username);
        Object response = this._client.doGet(getdata, true);
        if (this.hasError(response)) {
            return false;
        }
        JSONObject result = (JSONObject)((JSONObject)response).get("result");
        this._servertime = result.get("serverTime").toString();
        this._expiretime = result.get("expireTime").toString();
        this._servicetoken = result.get("token").toString();
        return true;
    }

    protected void checkLogin() {
    }

    protected String md5Hex(String input) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] hash = md.digest(input.getBytes());
        return new BigInteger(1, hash).toString(16);
    }

    public Object toJSON(String input) {
        return this._client.__jsondecode(input);
    }

    public String toJSONString(Object input) {
        return this._client.__jsonencode(input);
    }

    public boolean doLogin(String username, String vtigerUserAccessKey) {
        Object response;
        block4: {
            if (!this.__doChallenge(username)) {
                return false;
            }
            try {
                HashMap<String, String> postdata = new HashMap<String, String>();
                postdata.put("operation", "login");
                postdata.put("username", username);
                postdata.put("accessKey", this.md5Hex(String.valueOf(this._servicetoken) + vtigerUserAccessKey));
                response = this._client.doPost(postdata, true);
                if (!this.hasError(response)) break block4;
                return false;
            }
            catch (Exception ex) {
                this.hasError(ex);
                return false;
            }
        }
        JSONObject result = (JSONObject)((JSONObject)response).get("result");
        this._serviceuser = username;
        this._servicekey = vtigerUserAccessKey;
        this._sessionid = result.get("sessionName").toString();
        this._userid = result.get("userId").toString();
        return true;
    }

    public JSONArray doQuery(String query) {
        this.checkLogin();
        if (!query.trim().endsWith(";")) {
            query = String.valueOf(query) + ";";
        }
        HashMap<String, String> getdata = new HashMap<String, String>();
        getdata.put("operation", "query");
        getdata.put("sessionName", this._sessionid);
        getdata.put("query", query);
        Object response = this._client.doGet(getdata, true);
        if (this.hasError(response)) {
            return null;
        }
        JSONArray result = (JSONArray)((JSONObject)response).get("result");
        return result;
    }

    public List getResultColumns(JSONArray result) {
        ArrayList<String> columns = new ArrayList<String>();
        if (!result.isEmpty()) {
            JSONObject row = (JSONObject)result.get(0);
            Iterator iterator = row.keySet().iterator();
            while (iterator.hasNext()) {
                columns.add(iterator.next().toString());
            }
        }
        return columns;
    }

    public Map doListTypes() {
        this.checkLogin();
        HashMap<String, String> getdata = new HashMap<String, String>();
        getdata.put("operation", "listtypes");
        getdata.put("sessionName", this._sessionid);
        Object response = this._client.doGet(getdata, true);
        if (this.hasError(response)) {
            return null;
        }
        JSONObject result = (JSONObject)((JSONObject)response).get("result");
        JSONArray resultTypes = (JSONArray)result.get("types");
        HashMap returnvalue = new HashMap();
        for (Object value : resultTypes) {
            HashMap<String, String> returnpart = new HashMap<String, String>();
            returnpart.put("name", value.toString());
            returnvalue.put(value, returnpart);
        }
        return returnvalue;
    }

    public JSONObject doDescribe(String module) {
        this.checkLogin();
        HashMap<String, String> getdata = new HashMap<String, String>();
        getdata.put("operation", "describe");
        getdata.put("sessionName", this._sessionid);
        getdata.put("elementType", module);
        Object response = this._client.doGet(getdata, true);
        if (this.hasError(response)) {
            return null;
        }
        JSONObject result = (JSONObject)((JSONObject)response).get("result");
        return result;
    }

    public JSONObject doRetrieve(Object record) {
        this.checkLogin();
        HashMap<String, Object> getdata = new HashMap<String, Object>();
        getdata.put("operation", "retrieve");
        getdata.put("sessionName", this._sessionid);
        getdata.put("id", record);
        Object response = this._client.doGet(getdata, true);
        if (this.hasError(response)) {
            return null;
        }
        JSONObject result = (JSONObject)((JSONObject)response).get("result");
        return result;
    }

    public JSONObject doCreate(String module, Map valueMap) {
        this.checkLogin();
        if (!valueMap.containsKey("assigned_user_id")) {
            valueMap.put("assigned_user_id", this._userid);
        }
        HashMap<String, String> postdata = new HashMap<String, String>();
        postdata.put("operation", "create");
        postdata.put("sessionName", this._sessionid);
        postdata.put("elementType", module);
        postdata.put("element", this.toJSONString(valueMap));
        Object response = this._client.doPost(postdata, true);
        if (this.hasError(response)) {
            return null;
        }
        JSONObject result = (JSONObject)((JSONObject)response).get("result");
        return result;
    }

    public Object doInvoke(String method, Object params) {
        return this.doInvoke(method, params, "GET");
    }

    public Object doInvoke(String method, Object params, String type) {
        Map valueMap;
        this.checkLogin();
        HashMap<String, String> senddata = new HashMap<String, String>();
        senddata.put("operation", method);
        senddata.put("sessionName", this._sessionid);
        if (params != null && !(valueMap = (Map)params).isEmpty()) {
            for (Object key : valueMap.keySet()) {
                if (senddata.containsKey(key)) continue;
                senddata.put((String)key, (String)valueMap.get(key));
            }
        }
        Object response = null;
        response = type.toUpperCase() == "POST" ? this._client.doPost(senddata, true) : this._client.doGet(senddata, true);
        if (this.hasError(response)) {
            return null;
        }
        Object result = ((JSONObject)response).get("result");
        return result;
    }
}

